s           9 2                                         bp4422      Burster Digistant Type 4422                         Instrument Name: burster DIGISTANT Type 4422

  Description:   This instrument module provides
                 RS232 support for DIGISTANT
                 Type 4422 from burster.

  Functions and Classes:

  (1) Initialize :
      Initialize the instrument and sets to
      default configuration

  (2) Calculate:
      Set the Calculate settings of the instrument

  (3) Configure:
      Configures the instrument by setting the
      Voltage,Current,TC,RJ,RTD amd Output a Value

  (4) Measuring :
      Measuring functions of the DIGISTANT

  (5) Datalogger :
      Datalogger functions of the DIGISTANT

  (6) Ramp :
      Ramp functions of the DIGISTANT

  (7) System:
      Reads the system error
      Reads the instrument ID-String
      Controls the keyboard
      Sends a SCPI-Message
      Receives a SCPI-Message

  (8) Close :
      Takes the instrument off-line.
      *********
     |     Class Name:    Calculate

 Description:   Sets up all necessary functions
                for Calculate in the Digistant.     y     Class Name:    Configure

 Description:   Sets up all necessary functions
                for Configure the Digistant.     }     Class Name:    Measuring

 Description:   Sets up all necessary functions
                for mesuring with the Digistant.          Class Name:    Datalogger

 Description:   Sets up all necessary functions
                for working with the datalogger
                of the DIGISTANT          Class Name:    Ramp

 Description:   Sets up all necessary functions
                for working with the ramp function
                of the DIGISTANT          Class Name:    Display

 Description:   Sets up all necessary functions
                to config the Display of
                the DIGISTANT     r     Class Name:    System

 Description:   Sets up all necessary system
                functions of the Digistant.    0     Panel Name:    Initialize Serial

 Description:   Initializes the instrument by:
 1) finding an unused device in the device table
    using the supplied serial group and user
    address
 2) device clear and RESET  (if desired)
 3) returns the ID-String of the instrument
 4) returns an instrument ID
         Control Name:   COM-Port

 Description:    Specifies the COM-Port to be
                 used to communicate with the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1 - COM1   (=> Adress 0x3f8 IRQ4)
                 2 - COM2   (=> Adress 0x2f8 IRQ3)
                 3 - COM3   (=> Adress 0x3e8 IRQ4)
                 4 - COM4   (=> Adress 0x2e8 IRQ3)

 Default:        1         Control Name:   Baud Rate

 Description:    Specifies the baud rate of the
                 RS232-Port to communicate with
                 the instrument. This value must
                 correspond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   1200,2400,4800,9600 or 19200 baud

 Default:        9600    *     Control Name:   Time-out (seconds)

 Description:    Specifies  the time-out limit for
                 I/O operations.
                 A  value  of  0.0  will  disable
                 time-out altogether.

 Variable Type:  Double

 Valid Range:    0.060 to 100.0 seconds

 Default:        1.0    q     Control Name:   Bcc-Check

 Description:    This parameter switches the block
                 check function of the driver ON
                 or OFF.
                 This value must correspond to the
                 current internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF    |     Control Name:  Group Address

 Description:   Specifies the group address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal group address
                from the instrument.


 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0    w     Control Name:  User Adress

 Description:   Specifies the user address on the
                RS232 (RS485) to be used to
                communicate with the instrument.
                This value must correspond to the
                current internal user address
                from the instrument.

 Variable Type: Integer

 Valid Range:   0 to 15

 Default:       0          Control Name:  Instrument ID String

 Description:   Returns the ID-String of the
                instrument.

 Variable Type: String

    *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
          Control Name:  Reset

 Description:   If reset is on, a device clear and
 power on reset is done during initialization.

 Variable Type: Integer

 Valid Range:   0 to 1
                0 = off
                1 = on
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   COM-Port is out of range
       -2   Baud Rate is out of range
       -3   Time-out is out of range
       -4   Block Check parameter is out of range
       -5   Group Address is out of range
       -6   User Address is out of range
       -7   Reset Device is out of range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    	*  >           COM-Port                          
            Baud Rate                         N          Time-out (seconds)                
           Block Check                                   Group Address                     }            User Address                                Instrument ID-String                         Instrument ID                                Reset Device                                Error                                         1 1 2 2 3 3 4 4              41200 1200 2400 2400 4800 4800 9600 9600 19200 19200    2.0    On 1 Off 0    0    0    	            	           On 1 Off 0    	            v     Panel Name:    Calculate State

 Description:   Switch the calculate state of the
                instrument ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   State

 Description:    This parameter switches the
                 Calculate State of he device
                 ON or OFF.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range
       -4   Invalid Sense
       -3   Invalid Current Limit
  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

                 Instrument ID                      ]          State                                       Error                              1    On 1 Off 0    	            k     Panel Name:    Calculate Reset

 Description:   Reset Min/Max Value's of the
                instrument
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Range
       -4   Invalid Sense
       -3   Invalid Current Limit
  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    "'             Instrument ID                     #X          Error                              1    	                Panel Name:    Config Device

 Description:   Configure the instrument in
                following ways:

                - Selects the device mode of the
                  instrument
                - Selects the TC and RTD Type
                - Selects the TC and RTD Unit    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Mode

 Description:    This parameter switches the
                 mode of the device

 Variable Type:  Integer

 Valid Values:   0 = Input/Output
                 1 = Output
                 2 = Input

 Default:        0 = Input/Output    8     Control Name:   RTD-Type

 Description:    This parameter switches the
                 RTD-Type of the device

 Variable Type:  Integer

 Valid Values:   0 = PT100
                 1 = NI100
                 2 = PT200
                 3 = PT500
                 4 = PT1000


 Default:        0 = Input/Output         Control Name:   TC-Type

 Description:    This parameter switches the
                 TC-Type of the device

 Variable Type:  Integer

 Valid Values:   0 = R
                 1 = S
                 2 = B
                 3 = J
                 4 = T
                 5 = E
                 6 = K
                 7 = U
                 8 = L
                 9 = N
                10 = C
                11 = D
                12 = G2
                13 = M

 Default Value:  0 = R          Control Name:   TC-Unit

 Description:    This parameter switches the
                 TC-Unit of the device

 Variable Type:  Integer

 Valid Values:   0 = C
                 1 = F
                 2 = K

 Default Value:  0 = C         Control Name:   RTD-Unit

 Description:    This parameter switches the
                 RTD-Unit of the device

 Variable Type:  Integer

 Valid Values:   0 = Ohm
                 1 = C
                 2 = F
                 3 = K

 Default Value:  0 = Ohm    S     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Mode
       -3   Invalid RTD-Type
       -4   Invalid RTD-Unit
       -5   Invalid TC-Type
       -6   Invalid TC-Unit

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    (             Instrument ID                     )H            Mode                              *P +          RTD-Type                          +           TC-Type                           -}           TC-Unit                           .o -          RTD-Unit                          /}          Error                              1               IN/OUT 0 Output 1 Input 2               )PT100 0 NI100 1 PT200 2 PT500 3 PT1000 4               gTC-R 0 TC-S 1 TC-B 2 TC-J 3 TC-T 4 TC-E 5 TC-K 6 TC-U 7 TC-L 8 TC-N 9 TC-C 10 TC-D 11 TC-G2 12 TC-M 13               C 0 F 1  K 2               Ohm 0 C 1 F 2  K 3    	            T     Panel Name:    Config Pressure Mode

 Description:   Configure the Pressure Mode
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Module No

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:   Module No

 Description:    This parameter select the module no.

 Variable Type:  Integer

 Valid Values:   0-9

 Default:        0          Control Name:   Zero Point

 Description:    This parameter input the voltage zero point           
                 value

 Variable Type:  double
     x     Control Name:   Zero value

 Description:    This parameter input the final voltage value 

 Variable Type:  double
      h     Control Name:   Unit

 Description:    This parameter input the module unit

 Variable Type:  String
     m     Control Name:   Serial-No.

 Description:    This parameter input the serial no.

 Variable Type:  String
          Control Name:   Cal-Date

 Description:    This parameter input the cal-date of the
                 module

 Variable Type:  String
          Control Name:   Max.Value

 Description:    This parameter input the max. allowed module
                 value

 Variable Type:  double
     y     Control Name:   Zero pressure

 Description:    This parameter input the zero pressure value

 Variable Type:  double
     {     Control Name:   Final P-Value

 Description:    This parameter input the final pressure value

 Variable Type:  double
     5             Instrument ID                     7          Error                             9 [ ?         Module No.                        :d  l        Zero point                        ; J        Final Value                                                                                                            ; [    Z    Unit                              ; [     Z    Serial-No.                        <h [J    Z    Cal-Date                          <  l 	       Max.Value                         =          Zero pressure                     >
         Final  P-Value                     1    	                    
   (0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9 ?                                     ?                                        V    V             ?                                     ?                                     ?                                        _     Panel Name:    Get Config Pressure Module

 Description:   Get Configure pressure module 


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Module No

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:   Module No

 Description:    This parameter select the module no.

 Variable Type:  Integer

 Valid Values:   0-9

 Default:        0     h     Control Name:   Unit

 Description:    This parameter input the module unit

 Variable Type:  String
     i     Control Name:   Name

 Description:    This parameter input the module name

 Variable Type:  String

     m     Control Name:   Serial-No.

 Description:    This parameter input the serial no.

 Variable Type:  String
          Control Name:   Cal-Date

 Description:    This parameter input the cal-date of the
                 module

 Variable Type:  String
          Control Name:   Max.Value

 Description:    This parameter input the max. allowed module
                 value

 Variable Type:  double
          Control Name:   Zero Point

 Description:    This parameter input the voltage zero point           
                 value

 Variable Type:  double
     y     Control Name:   Zero pressure

 Description:    This parameter input the zero pressure value

 Variable Type:  double
     x     Control Name:   Zero value

 Description:    This parameter input the final voltage value 

 Variable Type:  double
      {     Control Name:   Final P-Value

 Description:    This parameter input the final pressure value

 Variable Type:  double
     B             Instrument ID                     D         Error                             F [ ?         Module No.                                                                                                             Gr [    Z    Unit                              G [ l    Z    Name                              HS [     Z    Serial-No.                        H [M    Z    Cal-Date                          IX  l 
       Max.Value                         I  l        Zero point                        J          Zero pressure                     K M        Final Value                       K  	       Final  P-Value                     1    	                    
   (0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9    V    V    	            	            	            	            	           	           	           	           	                Panel Name:    Config Grounding

 Description:   Configure the instrument in
                following ways:

                - Selects grounding function
                  of the instrument    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Mode

 Description:    This parameter switches the
                 grounding mode of the device

 Variable Type:  Integer

 Valid Values:   0 = Intern
                 1 = Extern
                 2 = Auto

 Default:        0 = Intern         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Mode

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    P~             Instrument ID                     Q m          Mode                              R          Error                              1               Extern 0 Intern 1 Auto 2    	           m     Panel Name:    Config Output TC-RJ

 Description:   Configure the instrument in
                following ways:

                - Selects the output Reference
                  junction
                - Input the manuel value for
                  the reference junction
                - Input the min and max. value
                  for reference junction

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    i     Control Name:   TC-Ref-Junction

 Description:    This parameter switches the
                 output TC-Reference Junction
                 of the device

 Variable Type:  Integer

 Valid Values:   0 = TC
                 1 = TC-RJ-Man
                 2 = TC-RJ Auto
                 3 = TC+ 4-20mA
                 4 = TC+ 0-20mA


 Default:        0 = TC          Control Name:   T-Man/T-Min

 Description:    Specifies  the T-Man for
                 TC-RJ-MAN or T-Min for
                 TC+ 4-20mA or TC+ 0-20mA function

 Variable Type:  Double

 Default:        0.0          Control Name:   T-Max

 Description:    Specifies  the T-Max for
                 TC+ 4-20mA or TC+ 0-20mA function

 Variable Type:  Double

 Default:        0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid TC-RJ-Junction

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
    W             Instrument ID                     X /          TC-Ref-Junction                   Za  |         T-Man/T-Min                       [< N         T-Max                             [          Error                              1               7TC 0 TC+RJ-Man 1 TC+RJ-Aut 2 TC+ 4-20mA 3 TC+ 0-20mA 4    0    0    	           k     Panel Name:    Config Intput TC-RJ

 Description:   Configure the instrument in
                following ways:

                - Selects the intput Reference
                  junction
                - Input the manuel value for
                  the reference junction
                - Input the min and max. value
                  for reference junction    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    K     Control Name:   TC-Ref-Junction

 Description:    This parameter switches the
                 intput TC-Reference Junction
                 of the device

 Variable Type:  Integer

 Valid Values:   0 = RJ-Int
                 1 = RJ-Man
                 2 = RJ-Ext
                 3 = RJ 4-20mA
                 4 = RJ 0-20mA
          Control Name:   T-Man/T-Min

 Description:    Specifies  the T-Man for
                 RJ-MAN or T-Min for
                 RJ 4-20mA or RJ+ 0-20mA function

 Variable Type:  Double

 Default:        0.0          Control Name:   T-Max

 Description:    Specifies  the T-Max for
                 RJ 4-20mA or RJ 0-20mA function

 Variable Type:  Double

 Default:        0.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid TC-RJ Junction

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
    a             Instrument ID                     b .          TC-Ref-Junction                   d  |         T-Man/T-Min                       d N         T-Max                             e          Error                              1               3RJ-Int 0 RJ-Man 1 RJ-Ext 2 RJ 4-20mA 3 RJ 0-20mA 4    0    0    	                 Panel Name:    Sets a Value

 Description:   Sets a Output value of the
                instrument in following ways:

                - Selects the output type
                - Selects the output range
                - Input the output value    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Output Type

 Description:   Specifices the Output type of
                the instrument .

 Variable Type: Integer

 Valid Range:   0 = Voltage
                1 = Current
                2 = Resistance
                3 = TCouple

 Default Range: 0 = Voltage    ,     Control Name:  Range

 Description:   Specifices the Output Range of
                the instrument .

 Variable Type : Integer

 Valid Range : 0 - Autorange
               1 -  10mV, 2mA,200
               2 - 100mV,20mA,2K
               3 -    1V,----,----
               4 -   101V,----,----          Control Name:  Voltage Value

 Description:   Specifices the voltage output
                value of the instrument .

 Variable Type: double
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Output Type
       -3   Invalid Output Range

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

    j             Instrument ID                     l            Output Type                       m:           Range                             nn           Value                             o          Error                              1               +Voltage 0 Current 1 Resistance 2 TCouple 3               HAutorange 0  10mV2mA200 1 100mV20mA2K 2   1 V,------ 3  11 V,------ 4    0    	                 Panel Name:    Start Measuring

 Description:   Start the measuring of instrument
                in following ways:

                - Selects the input type of the
                  instrument and start the
                  measuring    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.    |     Control Name:  Type

 Description:   Selects the measuring type of
                the instrument .

 Variable Type: Integer

 Valid Range:   0 = Voltage
                1 = Current
                2 = Resistance
                3 = TCouple
                4 = Presure
                5 = Presure and Current
                6 = Presure and Voltage

 Default Range: 0 = Voltage         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Type

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error
      317   Device Input and Output Over Error    t >            Instrument ID                     u ~          Type                              ws          Error                              1               aVoltage 0 Current 1 Resistance 2 TCouple 3 Presure 4 Presure and Current 5 Presure and Voltage 6    	            j     Panel Name:    Read Measure String

 Description:   Read the measurment value as
                string    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     }     Control Name:  Value

 Description:   Returns the Value-String of the
                instrument.

 Variable Type: String
    0     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error
      317   Device Input and Output Over Error
      350   Measure is not started
      351   Timeout => no measure values    }
             Instrument ID                     ~; m          Value                             ~          Error                              1    	            	            v     Panel Name:    Read Measure Value

 Description:   Read the measurment value as
                double and the unit    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.     u     Control Name:  Value

 Description:   Returns the Value of the
                instrument.

 Variable Type: double     s     Control Name:  Unit

 Description:   Returns the Unit of the
                instrument.

 Variable Type: String         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error
      350   Measure is not started
      351   Timeout => no measure values    2             Instrument ID                     c }          Value                              }@         Unit                              [          Error                              1    	           	            	            }     Panel Name:    Read Pressure Measure String

 Description:   Read the pressure measurement value as
                string    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Presure Value

 Description:   Returns the presure value-String of the
                instrument.

 Variable Type: String
    X     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error
      317   Device Input and Output Over Error
      318   Device Presure Over Error  
      350   Measure is not started
      351   Timeout => no measure values                 Instrument ID                      o          Pressure Value                              Error                              1    	            	                 Panel Name:    Read Pressure Measure Value

 Description:   Read the pressure measurment value as
                double and the unit    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Presure Value

 Description:   Returns the presure value of the
                instrument.

 Variable Type: double          Control Name:  Presure Unit

 Description:   Returns the presure unit of the
                instrument.

 Variable Type: String    X     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error
      317   Device Input and Output Over Error
      318   Device Presure Over Error  
      350   Measure is not started
      351   Timeout => no measure values    X             Instrument ID                      }          Pressure Value                     }@         Pressure Unit                               Error                              1    	           	            	            C     Panel Name:    Stop Measuring

 Description:   Abort the measure    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error    I             Instrument ID                     z          Error                              1    	            j     Panel Name:    Select Pressure Module by No.

 Description:   Select the active pressure module by no.
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Mode

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:   Module No

 Description:    This parameter select the module no.

 Variable Type:  Integer

 Valid Values:   0-9

 Default:        0    $             Instrument ID                     U          Error                              \         Module No.                         1    	                    
   (0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9    n     Panel Name:    Select Pressure Module by Name.

 Description:   Select the active pressure module by name.
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Mode

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

     r     Control Name:   Module Name

 Description:    This parameter select the module name.

 Variable Type:  String

                 Instrument ID                     @          Error                              z          Module Name                        1    	                U     Panel Name:    Tare Pressure State

 Description:   Sets the tare state ON or OFF
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid State

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT


          Control Name:   State

 Description:    This parameter switches the
                 tare presure state of the device
                 ON or OFF.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF                 Instrument ID                               Error                             z o          State                              1    	            On 1 Off 0    d     Panel Name:    Tare Pressure Initate

 Description:   This function initate the tare measurement
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      319   The module batterie is lower than 100mV
                 Instrument ID                               Error                              1    	            O     Panel Name:    Get Tare Pressure Value

 Description:   Get the tare value

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      319   The module batterie is lower than 100mV
          Control Name:  Presure Value

 Description:   Returns the presure value-String of the
                instrument.

 Variable Type: String
    r             Instrument ID                               Error                             | w          Tare Value                         1    	            	            W     Panel Name:    Get Pressure Module Name

 Description:   Get pressure module name


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Module No

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:   Module No

 Description:    This parameter select the module no.

 Variable Type:  Integer

 Valid Values:   0-9

 Default:        0     i     Control Name:   Name

 Description:    This parameter input the module name

 Variable Type:  String

    ,             Instrument ID                     ]          Error                               [ ?         Module No.                              Z    Name                               1    	                    
   (0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9    	            W     Panel Name:    Set Pressure Module Name

 Description:   Set pressure module name


    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Module No

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

          Control Name:   Module No

 Description:    This parameter select the module no.

 Variable Type:  Integer

 Valid Values:   0-9

 Default:        0     i     Control Name:   Name

 Description:    This parameter input the module name

 Variable Type:  String

    ÷             Instrument ID                               Error                             ǫ [ ?         Module No.                        J      Z    Name                               1    	                    
   (0 0 1 1 2 2 3 3 4 4 5 5 6 6 7 7 8 8 9 9    	                 Panel Name:    Check Pressure Module Batterie

 Description:   Check the pressure module batterie state

                If the batterie voltage higher than 100mV,
                the battiere is ok.    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      319   The module batterie is lower than 100mV
     g     Control Name:   Batterie Value

 Description:    Return the batterie value

 Variable Type:  String
    ʵ             Instrument ID                               Error                             ο o         Value                              1    	            	            v     Panel Name:    Datalogger Clear All

 Description:   Clear all datalogger block's in
                the instrument    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty    h             Instrument ID                     љ          Error                              1    	            z     Panel Name:    Datalogger Clear Block

 Description:   Clear one datalogger block No. in
                the instrument    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Block No.

 Description:    Specifies the datalogger Block No

 Variable Type:  integer

 Valid Range:    1 to 256

 Default:        1         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Block No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty    Մ             Instrument ID                     ֵ m           Block No.                         V          Error                              1    1    	            v     Panel Name:    Datalogger Mode

 Description:   Switch the datalogger mode of the
                instrument ON/OFF    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Datalogger mode

 Description:    This parameter switches the
                 Datalogger Mode of the device
                 ON or OFF.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF          Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Mode


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty    ە             Instrument ID                      p          Mode                              ݿ          Error                              1    On 1 Off 0    	            p     Panel Name:    Datalogger Start/Stop

 Description:   Switch between datalogger Start or
                Stop    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:   Datalogger Start/Stop

 Description:    This parameter switches the
                 Datalogger Start/Stop of the
                 device ON or OFF.

 Variable Type:  Integer

 Valid Values:   0 = Stop, 1 = Start

 Default:        0 = Stop
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Start/Stop

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty                 Instrument ID                     . m           Start/Stop                        9          Error                              1    Start 1 Stop 0    	            T     Panel Name:    Datalogger Step

 Description:   Recording one Value in Datalogger    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty    d             Instrument ID                               Error                              1    	            n     Panel Name:    Sets Datalogger Time

 Description:   Sets the Timer Value in the
                Datalogger    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Datalogger Time (seconds)

 Description:    Specifies  the datalogger timer

 Variable Type:  Double

 Valid Range:    0.0 to 3600.0 seconds

 Default:        1.0
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Time

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty    t             Instrument ID                      m          Time                              c          Error                              1    1.0    	                 Panel Name:    Read Datalogger Aver+Dev

 Description:   Read the Average and the deviation
                from the selected Block No in the
                Datalogger
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Block No.

 Description:    Specifies the datalogger Block No

 Variable Type:  integer

 Valid Range:    1 to 256

 Default:        1          Control Name:  Average

 Description:   Returns the average of the
                selected Block No.

 Variable Type: double
          Control Name:  Deviation

 Description:   Returns the deviation of the
                selected Block No.

 Variable Type: double          Control Name:  unit

 Description:   Returns the unit from average and
                and deviation of the selected
                Block No.

 Variable Type: String         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Block No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty                 Instrument ID                                 Block No.                          m          Average                           0 m          Deviation                          m         Unit                              m          Error                              1    1    	           	           	            	                 Panel Name:    Read Datalogger Max+Min

 Description:   Read the Minimum and Maximum Value
                from the selected Block No in the
                Datalogger    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Block No.

 Description:    Specifies the datalogger Block No

 Variable Type:  integer

 Valid Range:    1 to 256

 Default:        1          Control Name:  Min.Value

 Description:   Returns the Min.Value of the
                selected Block No.

 Variable Type: double
          Control Name:  Max.Value

 Description:   Returns the Max.Value of the
                selected Block No.

 Variable Type: double          Control Name:  unit

 Description:   Returns the unit from average and
                and deviation of the selected
                Block No.

 Variable Type: String         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Block No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty                 Instrument ID                                 Block No.                         u m          Min.Value                          m          Max.Value                          m         Unit                              ?          Error                              1    1    	           	           	            	                 Panel Name:    Read Datalogger Value as String

 Description:   Read the Measure Value,Date and
                Time from the selected Memory No
                in the Datalogger    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Memory No.

 Description:    Specifies the datalogger MemoryNo

 Variable Type:  integer

 Valid Range:    1 to 256

 Default:        1          Control Name:  Block No.

 Description:   Returns the Block No. of the
                selected Memory No.

 Variable Type: String     {     Control Name:  Date

 Description:   Returns the Date of the
                selected Memory No.

 Variable Type: String     {     Control Name:  Time

 Description:   Returns the Time of the
                selected Memory No.

 Variable Type: String          Control Name:  Value

 Description:   Returns the value and unit of the
                selected Memory No.

 Variable Type: String         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty                Instrument ID                                Memory-No.                       S $          Block-No.                         m          Date                             c m          Time                              m$         Value                            	t          Error                              1    1    	            	            	            	            	                 Panel Name:    Read Datalogger Value

 Description:   Read the Measure Value,Date and
                Time from the selected Memory No
                in the Datalogger    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Memory No.

 Description:    Specifies the datalogger MemoryNo

 Variable Type:  integer

 Valid Range:    1 to 256

 Default:        1          Control Name:  Block No.

 Description:   Returns the Block No. of the
                selected Memory No.

 Variable Type: String     {     Control Name:  Date

 Description:   Returns the Date of the
                selected Memory No.

 Variable Type: String     {     Control Name:  Time

 Description:   Returns the Time of the
                selected Memory No.

 Variable Type: String     }     Control Name:  Value

 Description:   Returns the Value of the
                selected Memory No.

 Variable Type: double     {     Control Name:  Unit

 Description:   Returns the Unit of the
                selected Memory No.

 Variable Type: String         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Memory No.

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty                Instrument ID                                Memory-No.                        $          Block-No.                        M m          Date                              m          Time                             S m$         Value                             m         Unit                             [          Error                              1    1    	            	            	            	           	            	            c     Panel Name:    Ramp Mode

 Description:   Switch the ramp mode of the
                instrument    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Ramp Mode

 Description:    This parameter switches the
                 Ramp Mode of the

 Variable Type:  Integer

 Valid Values:   0 = OFF
                 1 = Ramp1
                 2 = Ramp2

 Default:        0 = OFF         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Ramp mode

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty                Instrument ID                     m&          Mode                                       Error                              1               Off 0 Ramp1 1 Ramp2 2    	            d     Panel Name:    Ramp Start/Stop

 Description:   Switch between ramp Start or
                Stop    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Ramp Start/Stop

 Description:    This parameter switches the
                 Ramp Start/Stop of the
                 device ON or OFF.

 Variable Type:  Integer

 Valid Values:   0 = Stop, 1 = Start

 Default:        0 = Stop
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Start/Stop

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   C             Instrument ID                     t m           Start/Stop                       !s          Error                              1    Start 1 Stop 0    	            I     Panel Name:    Ramp Step

 Description:   Toggle to the next ramp step    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Ramp Step Mode

 Description:    This parameter switches the
                 Ramp Step of the device
                 ON or OFF.

 Variable Type:  Integer

 Valid Values:   0 = Up, 1 = Down

 Default:        0 = Up
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Ramp Step

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   %             Instrument ID                    & m           Mode                             '          Error                              1    Down 1 Up 0    	                Panel Name:    Init Ramp1

 Description:   Initiated the ramp function 1
                of the instrument in following
                ways :

                - Select the waveform
                - Input the number of counts
                - Input the step time
                - Select the output type and unit
                - Input the start value
                - Input the end value
                - Input the step value

    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Wavefrom

 Description:    This parameter selected the
                 Waveform  of ramp1

 Variable Type:  Integer

 Valid Values:   0 = Triangle
                 1 = Sawtooth

 Default:        0 = Triangle          Control Name:   Number of Counts

 Description:    Specifies the number of counts
                 of ramp1

 Variable Type:  Integer

 Valid Range:    1 to 99
                 0 = Countiue

 Default:        10
          Control Name:   Step Time (seconds)

 Description:    Specifies  the step time

 Variable Type:  Double

 Valid Range:    0.1 to 99999.9 seconds

 Default:        1.0
    )     Control Name:   Type and Unit

 Description:    Specifies the output type and the
                 unit of start, stop and step
                 value

 Variable Type:  Integer

 Valid Range:    0 = Voltage [V]
                 1 = Voltage [mV]
                 2 = Current [mA]
                 3 = TC      [C]
                 4 = TC      [F]
                 5 = TC      [K]
                 6 = RTD     [Ohm]
                 7 = RTD     [C]
                 8 = RTD     [F]
                 9 = RTD     [K]

 Default:        0 = Voltage [V]
    5     Control Name:   Start Value

 Description:    Specifies the start value of
                 ramp1

 Variable Type:  Double

 Valid Range:    by Voltage -11 to 11V
                 by Current -22 to 22mA
                 by TC      0   to 3000
                 by RTD     0   to 3000

 Default:        0.0

    2     Control Name:   End Value

 Description:    Specifies the End value of
                 ramp1

 Variable Type:  Double

 Valid Range:    by Voltage -11 to 11V
                 by Current -22 to 22mA
                 by TC      0   to 3000
                 by RTD     0   to 3000

 Default:        0.0


    2     Control Name:   Step Value

 Description:    Specifies the step value of
                 ramp1

 Variable Type:  Double

 Valid Range:    by Voltage -11 to 11V
                 by Current -22 to 22mA
                 by TC      0   to 3000
                 by RTD     0   to 3000

 Default:        0.0
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Waveform
       -3   Invalid Number of Counts
       -4   Invalid Step Time
       -5   Invalid Type
       -6   Invalid Start Value
       -7   Invalid End Value
       -8   Invalid Step Value


  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   ->             Instrument ID                    .o            Waveform                         /Z @          Number of Counts                 08          Step Time[sec]                   0 ~ d          Type and Unit                    3 }          Start Value                      4X }9         End Value                        5 }         Step Value                       6          Error                              1    Sawtooth 1 Triangle 0    1    1.0            
   Voltage  [V] 0 Voltage  [mV] 1 Current [mA] 2 TC      [C] 3 TC      [F] 4 TC       [K] 5 RTD    [Ohm] 6 RTD     [C] 7 RTD     [F] 8 RTD      [K] 9    0.0    0.0    0.0    	                 Panel Name:    Init Ramp2

 Description:   Initiated the ramp function 2
                of the instrument in following
                ways :

                - Select the waveform
                - Input the number of counts
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Wavefrom

 Description:    This parameter selected the
                 Waveform  of ramp2

 Variable Type:  Integer

 Valid Values:   0 = Triangle
                 1 = Sawtooth

 Default:        0 = Triangle          Control Name:   Number of Counts

 Description:    Specifies the number of counts
                 of ramp2

 Variable Type:  Integer

 Valid Range:    1 to 99
                 0 = Countiue

 Default:        10
          Control Name:   Number of Points

 Description:    Specifies the number of points
                 of ramp2

 Variable Type:  Integer

 Valid Range:    2 to 30

 Default:        2
    O     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Waveform
       -3   Invalid Number of Counts
       -4   Invalid Number of points


  1 - 124   RS-232 error (see RS-232 Library
            error codes)


      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   >M             Instrument ID                    ?~ }           Waveform                         @i }           Number of Counts                 AG }G          Number of Points                 B          Error                              1    Sawtooth 1 Triangle 0    1    2    	           A     Panel Name:    Init Ramp2 List

 Description:   Initiated the ramp function 2
                of the instrument in following
                ways :

                - Select the output type and unit
                - Input the List No.
                - Input the List value
                - Input the List step time
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   List No.

 Description:    Specifies the List No. of the
                 input values

 Variable Type:  Integer

 Valid Range:    1 to 30

 Default:        1
    9     Control Name:   Value

 Description:    Specifies the value of the
                 selected List No.

 Variable Type:  Double

 Valid Range:    by Voltage -11 to 11V
                 by Current -22 to 22mA
                 by TC      0   to 3000
                 by RTD     0   to 3000

 Default:        0.0

          Control Name:   Step Time (seconds)

 Description:    Specifies the step time of the
                 selected List No.

 Variable Type:  Double

 Valid Range:    0.1 to 99999.9 seconds

 Default:        1.0
    T     Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Type
       -3   Invalid List No.
       -4   Invalid Value
       -5   Invalid Step Time

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty    )     Control Name:   Type and Unit

 Description:    Specifies the output type and the
                 unit of start, stop and step
                 value

 Variable Type:  Integer

 Valid Range:    0 = Voltage [V]
                 1 = Voltage [mV]
                 2 = Current [mA]
                 3 = TC      [C]
                 4 = TC      [F]
                 5 = TC      [K]
                 6 = RTD     [Ohm]
                 7 = RTD     [C]
                 8 = RTD     [F]
                 9 = RTD     [K]

 Default:        0 = Voltage [V]
   G             Instrument ID                    I }           List No.                         I }@         Value                            K }         Step Time[sec]                   K          Error                            OF  r          Type and Unit                      1    1    0.0    1.0    	                    
   Voltage  [V] 0 Voltage  [mV] 1 Current [mA] 2 TC      [C] 3 TC      [F] 4 TC       [K] 5 RTD    [Ohm] 6 RTD     [C] 7 RTD     [F] 8 RTD      [K] 9         Panel Name:    Display Backlight

 Description:   Switch the Display Backlight ON
                or Off and selected the time of
                when the Backlight is on    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Backlight State

 Description:    This parameter switches the
                 Backlight of the device display
                 ON or OFF.

 Variable Type:  Integer

 Valid Values:   0 = OFF, 1 = ON

 Default:        0 = OFF          Control Name:   Backlight Time

 Description:    This parameter inputs the time
                 when the display backlight is
                 on.

 Variable Type:  Double

 Valid Values:   1.0 to 60.0 Seconds.

 Default:        1.0         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid State
       -3   Invalid Time

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   T4             Instrument ID                    Ue m           State                            V` m9         Time                             WT          Error                              1    On 1 Off 0    1.0    	            r     Panel Name:    Display Contrast

 Description:   Adjust the display contrast of the
                instrument
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:   Display Contrast

 Description:    Specifies the dispaly contrast

 Variable Type:  Double

 Valid Range:    0.0 to 1.0

 Default:        0.5
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID
       -2   Invalid Contrast

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

      320   Datalogger is empty   [             Instrument ID                    ] m          Contrast                         ]          Error                              1    0.5    	            a     Panel Name:   System Error

 Description:  Reads the system error of the
               device    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  System Error

 Description:   Displays the SCPI system error


 Variable Type: String
                (see manual Resistomat Type 6706)
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0     Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT
   a             Instrument ID                    c m          System Error                     c          Error                              1    	            	            E     Panel Name:   Get Status

 Description:  Returns the device status    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrumet ID

      310   Device Voltage Error
      311   Device Current Error
      312   Device Temperature Error
      313   Device Calibration Error
      314   Device In Over Error
      315   Device Out Over Error
      316   Device Lowbat Error
      317   Device Input and Output Over Error

  1 - 124   RS-232 error (see RS-232 Library
            error codes)

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   gT >            Instrument ID                    h          Error                              1    	            U     Panel Name:   System Keybroad

 Description:  Controls the keybroad of the device
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Keyboard

 Description:   This parameter locks the keyboard
                on the front panel of the
                instrument

 Variable Type: Integer

 Valid Range:   0  = Unlocked
                1  = Locked         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID
       -2   Invalid Value

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   mK             Instrument ID                    n| m           Keyboard                         oj          Error                              1    Locked 1 Unlocked 0    	            c     Panel Name:   Send a SCPI-Message

 Description:  Sends a SCPI-Message to a
               slave    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.          Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input the SCPI-message
                without the LineFeed termination.

 Example      : ":SENS:CORR:STATE ON"

 Variable Type: String
         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT

   s?             Instrument ID                    tp }          Send-SCPI-Message                uq          Error                              1        	                 Panel Name:   Receive a SCPI-Message

 Description:  Sends "Query form" from SCPI-
               Message and receive a answers
    )     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.         Control Name:  Send SCPI-Message

 Description:   This control is a string parameter
                You must input Query-Form from
                the SCPI-message without the
                Line Feed termination.

 Example      : ":SENS:CORR:STATE?"

 Variable Type: String          Control Name:  Answer from Slave

 Description:   This control return a string from
                the slave.

 Variable Type: String (Length => see the 6706
                        Manual SCPI-Commands)         Control Name:  Error

 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      220   Unable to open instrument
      221   Unable to close instrument
      224   Error clearing instrument
      230   Error writing to instrument
      231   Error reading from instrument
      232   Instrument not initialized
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      237   Error configuring EOS terminator

      300   The instrument sends NAK
      301   The instrument sends EOT   y9             Instrument ID                    zj }          Send-SCPI-Message                { }G         Instrument Answers               |`          Error                              1        	            	                Panel Name:    Close

 Description:   Takes the instrument off-line.

 Note: The  instrument must  be reinitialized
       to use it again.    *     Control Name:  Instrument ID

 Description:   The initialize function call
 returns an instrument ID, which is used as an
 input here.  (The ID is used to select among
 like-instruments).

 Variable Type: Integer

 Valid Range:   1 to 10 (typical)
 The value 10 is set internally in the driver.
         Control Name:  Error


 Description:   Displays the results of the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Invalid Instrument ID

      221   Unable to close instrument
      232   Instrument not initialized   q             Instrument ID                              Error                              1    	                    o 
    K.    init                                     4        K.    calc_state                               !  &}     K.    calc_reset                               &  2     K.    config                                   5u  > 
    K.    config_p_module                          Bx  L     K.    get_config_p_module                      O  Ur     K.    config_grounding                         VJ  ^     K.    config_output_tc_rj                      `  h     K.    config_input_tc_rj                       i  r     K.    set_value                                s  {x     K.    start_measure                            |       K.    read_measure_string                        d     K.    read_measure                             a       K.    read_p_measure_string                           K.    read_p_measure                             7     K.    stop_measure                                    K.    select_p_module_no                         x     K.    select_p_module_name                     ,  l     K.    tare_p_state                             *       K.    tare_p_init                                     K.    get_tare_p_value                           0     K.    get_p_module_name                        X  Ȼ     K.    store_p_module_name                        .     K.    check_p_module_batterie                    ԇ     K.    clear_all_datalogger                       b     K.    clear_datalogger_block                          K.    set_datalogger_mode                        F     K.    datalogger_start_stop                           K.    datalogger_step                            j     K.    set_datalogger_time                      !  y     K.    datalogger_aver_devi                      K     K.    datalogger_min_max                            K.    read_datalogger                         : h     K.    read_datalogger_value                   b      K.    set_ramp_mode                            $     K.    ramp_start_stop                         %B *     K.    ramp_step                               + : 	    K.    init_ramp1                              =_ E]     K.    init_ramp2                              F Qw     K.    init_ramp2_list                         S Zu     K.    set_display_backlight                   [o `     K.    set_display_contrast                    a fK     K.    system_error                            g ls     K.    get_status                              l r
     K.    system_keyboard                         r w     K.    send_scpi                               x ~     K.    receive_scpi                                  K.    close                                                                       DInitialize                          Calculate                            DCalculate State                      DCalculate Reset                     Configure                            DConfig Device                        DConfig Pressure Module               DGet Config Pressure Module           DConfig Grounding                     DConfig Output TC-RJ                  DConfig Input TC-RJ                   DSets a Value                        Measuring                            DStart Measure                        DRead Measure String                  DRead Measure Value                   DRead Pressure Measure String         DRead Pressure Measure Value          DStop Measure                      Presure Functions                    DSelect Pressure Module by No.        DSelect Pressure Module by Name       DTare Pressure State                  DTare Pressure Initiate               DGet Tare Pressure Value              DGet Pressure Module Name             DSet Pressure Module Name             DCheck Pressure Module Batterie      Datalogger                           DDatalogger Clear All                 DDatalogger Clear Block               DDatalogger Mode                      DDatalogger Start/Stop                DDatalogger Step                      DSets Datalogger Time                 DRead Datalogger Aver+Dev             DRead Datalogger Min/Max              DRead Datalogger (String)             DRead Datalogger Value               <Ramp                                 DRamp Mode                            DRamp Start/Stop                      DRamp Step                            DInit. Ramp1                          DInit. Ramp2                          DInit. Ramp2 List                    Display                              DDisplay Backlight                    DSet Display Contrast                xSystem                               DSystem Error                         DGet Status                           DSystem Keyboard                      DSend a SCPI-Message                  DReceive a SCPI-Message               DClose                           